/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class PiercingModifier
extends IncrementalModifier {
    private static final ResourceLocation PIERCING_DEBUFF = TConstruct.getResource("piercing_debuff");

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        float toRemove = 0.5f * this.getScaledLevel(context, level);
        float baseDamage = context.getBaseStats().get(ToolStats.ATTACK_DAMAGE).floatValue();
        if (baseDamage < toRemove) {
            volatileData.putFloat(PIERCING_DEBUFF, toRemove - baseDamage);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        float toRemove = 0.5f * this.getScaledLevel(context, level) - context.getVolatileData().getFloat(PIERCING_DEBUFF);
        ToolStats.ATTACK_DAMAGE.add(builder, -toRemove);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        Player player = context.getPlayerAttacker();
        DamageSource source = player != null ? DamageSource.m_19344_((Player)player) : DamageSource.m_19370_((LivingEntity)context.getAttacker());
        source.m_19380_();
        float secondaryDamage = (this.getScaledLevel(tool, level) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE) - tool.getVolatileData().getFloat(PIERCING_DEBUFF)) * context.getCooldown();
        if (context.isCritical()) {
            secondaryDamage *= 1.5f;
        }
        ToolAttackUtil.attackEntitySecondary(source, secondaryDamage, context.getTarget(), context.getLivingTarget(), true);
        return 0;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) - tool.getVolatileData().getFloat(PIERCING_DEBUFF), tooltip);
    }
}

